﻿///
/// ファイルに対する処理関数を宣言するヘッダファイル。
///

#if       !defined(INCLUDED_SZ_FILE)
#define            INCLUDED_SZ_FILE

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

SZ_NS_BEG(szpp)

/// <summary>
/// パス文字列に対応するファイルが実際に存在するかどうかを調べる関数。
/// </summary>
/// <param name="path">ファイルが実際に存在するかどうかを調べるパス文字列。</param>
SZ_SPEC
bool FileExists(const szstring &path);

/// <summary>
/// パス文字列に対応するディレクトリが実際に存在するかどうかを調べる関数。
/// </summary>
/// <param name="path">ディレクトリが実際に存在するかどうかを調べるパス文字列。</param>
SZ_SPEC
bool DirectoryExists(const szstring &path);

/// <summary>
/// ファイルのサイズを調べる関数。
/// </summary>
/// <param name="fileName">サイズを調べたいファイルのパス文字列。</param>
SZ_SPEC
u64 GetFileSize(const szstring &fileName);

/// ハンドルのリソース管理のためのクラス
class WinHandle : boost::noncopyable
{
private:
  HANDLE m_handle;
public:
  WinHandle(HANDLE handle) : m_handle(handle) {}
  ~WinHandle() { if (INVALID_HANDLE_VALUE != m_handle) CloseHandle(m_handle); }
  
  operator HANDLE () { return m_handle; }
  HANDLE Get() const { return m_handle; }
};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_PATH)
